<?php
/**
 * @package Plugin accessbyip for Joomla! 2.5 and later
 * @version 1.0.2 Dated: 2013-Feb-04
 * @author James brice
 * @copyright Copyright (C) 2012 James Brice. All rights reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

// No direct access
defined('_JEXEC') or die;

class plgAuthenticationAccessbyip extends JPlugin {
	/**
	 * This method should handle any authentication and report back to the subject
	 *
	 * @access	public
	 * @param  array	$credentials Array holding the user credentials (not used in this plugin)
	 * @param	array   $options	Array of extra options
	 * @param	object	$response	Authentication response object
	 * @return	boolean
	 * @since 1.5
	 */
	function onUserAuthenticate($credentials, $options, & $response) {

		// Get web client's IP address (NB ip2long() returns false if not a valid IP string)
		$incoming_ip 	= 	ip2long ($_SERVER['REMOTE_ADDR']);

		// load plugin params info
		$permitted_ip	= ip2long ($this->params->get('permitted_ip'));
		$subnet_mask	= ip2long ($this->params->get('subnet_mask'));
		$selected_user 	= & JFactory::getUser($this->params->get('user_id'));
		$allow_opt_out	= $this->params->get('allow_opt_out', '0');
		$opt_out		= ($allow_opt_out !== '0')
						  &&
						  ($_POST['login_mode'] !== 'accessbyip');
		$allow_backend	= $this->params->get('allow_backend', '0');
		$no_backend		= ($allow_backend == '0')
						  &&
						  ($options['action'] == 'core.login.admin');

		// Look to see if IP addresses and sub-net mask look OK
		$ips_invalid	= !($incoming_ip && $permitted_ip && $subnet_mask);

		// by default - block any auto-login
		$permitted	= FALSE;

		$message	= '';

		switch (TRUE) {
			// check for valid IP address info.
		    case $ips_invalid:
		        break;
			// check if authentication required
			case $opt_out:
				break;
			// don't authenticate here if login to the backend blocked
		    case $no_backend:
		        break;
		    // check that login is still using a valid user
		    case !isset($selected_user->username) || $selected_user->block:
		    	break;
		    //check IP params and incoming IP for validity
			// XOR gives 0s if equivalent bits are the same same,
			//  and clear "don't care" range of LSBs by ANDing with subnet mask
			//  (This method avoids differing behaviour in 32- and 64-bit implementations of PHP.)
		    case !(($incoming_ip ^ $permitted_ip) & $subnet_mask):
		        $permitted 	= TRUE;
		        break;
		}

		if ($permitted) {
			// set up response to confirm authentication
			$response->status		= JAuthentication::STATUS_SUCCESS;
			$response->error_message = '';
			// Use credentials of pre-set user to log in
			$response->username = $selected_user->username;
			$response->fullname = $selected_user->name;
		}
		else {
			// set up response to deny authentication at this stage
			$response->status		= JAuthentication::STATUS_FAILURE;
			$response->error_message	= JText::sprintf('JGLOBAL_AUTH_FAILED', '$message');
		}
	}
}





