<?php
/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version 2.0
 * @revision 676
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) 2013 by CodeGravity.com - All rights reserved!
 * @website http://www.extrawatch.com
 */
class ExtraWatchVisitorsWidget extends WP_Widget {

  function ExtraWatchVisitorsWidget()
  {
    $widget_ops = array('classname' => 'ExtraWatchVisitorsWidget', 'description' => 'Optional ExtraWatch widget which displays visitor statistics and their countries' );
    $this->WP_Widget('ExtraWatchVisitorsWidget', 'ExtraWatch Visitors', $widget_ops);
  }

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
  }

  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    return $instance;
  }

  function widget($args, $instance)
  {
    $extraWatchPluginDir = realpath(dirname(realpath(__FILE__)).DS."..".DS."..".DS."..".DS."..".DS."..".DS."..".DS);
    include_once $extraWatchPluginDir.DS."modules".DS."mod_extrawatch_visitors" . DS . "mod_extrawatch_visitors.php";
    echo renderExtraWatchVisitors();
  }

}

/*register widget */
function ExtraWatchVisitorsWidget_init()
{
  register_widget('ExtraWatchVisitorsWidget');
}


add_action('widgets_init', 'ExtraWatchVisitorsWidget_init');

