<?php
/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version 2.0
 * @revision 676
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) 2013 by CodeGravity.com - All rights reserved!
 * @website http://www.extrawatch.com
 */

class ExtraWatchAgentWidget extends WP_Widget {

  function ExtraWatchAgentWidget()
  {
    $widget_ops = array('classname' => 'ExtraWatchAgentWidget', 'description' => 'Essential ExtraWatch widget to record all visits' );
    $this->WP_Widget('ExtraWatchAgentWidget', 'ExtraWatch Agent', $widget_ops);
  }

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
  }

  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    return $instance;
  }

  function widget($args, $instance)
  {
    $extraWatchPluginDir = realpath(dirname(realpath(__FILE__)).DS."..".DS."..".DS."..".DS."..".DS."..".DS."..".DS);
    include_once $extraWatchPluginDir.DS."modules".DS."mod_extrawatch_agent" . DS . "mod_extrawatch_agent.php";
    echo renderExtraWatchAgent();
  }

}

/*register widget */
function ExtraWatchAgentWidget_init()
{
  register_widget('ExtraWatchAgentWidget');
}


add_action('widgets_init', 'ExtraWatchAgentWidget_init');

