<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version 2.0
 * @revision 676
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) 2013 by CodeGravity.com - All rights reserved!
 * @website http://www.extrawatch.com
 */

/** ensure this file is being included by a parent file */
if (!defined('_JEXEC') && !defined('_VALID_MOS'))  {
  die('Restricted access');
}

class ExtraWatchSetupJoomla implements ExtraWatchSetup
{

  public $env;
  public $database;

  function ExtraWatchSetupJoomla()
  {
    $this->env = ExtraWatchEnvFactory::getEnvironment();
    $mainframe = & JFactory :: getApplication('site');
    $mainframe->initialise();
    $this->database = & JFactory :: getDBO();
  }

  function install()
  {
    if ("1.5" == "1.5" && !version_compare(JVERSION, '1.6.0', '<')) {
      echo("<span style='color: red'><h2>Error: You are using joomla " . JVERSION . " but the installation package is for version 1.5 ! Uninstall this version, <a href='http://www.extrawatch.com/download'>Go to download section</a>, download the package for Joomla " . JVERSION . ", and install again.</h2></span>");
      return -1;
    } elseif ("1.5" == "1.6" && !version_compare(JVERSION, '1.6.0', '>=')) {
      echo("<span style='color: red'><h2>Error: You are using joomla " . JVERSION . " but the installation package is for version 1.5 ! Uninstall this version, <a href='http://www.extrawatch.com/download'>Go to download section</a>, download the package for Joomla " . JVERSION . ", and install again.</h2></span>");
      return -1;
    }

    $i = 0;
    $numberOfFiles = 64;
    for ($j = 1; $j <= $numberOfFiles; $j++) {
      $fileName = JPATH_SITE . DS . "components" . DS . "com_extrawatch" . DS . "sql" . DS . "extrawatch-$j.sql";
      $lines = file($fileName);
      if (!$lines) {
        die("<span style='color: red'>Error reading file: $fileName, your joomla site path is set to: " . JPATH_SITE . " what is probably not correct, check configuration.php</span><br/>");
      }
      $query = "";
      foreach ($lines as $line_num => $line) {
        $query .= trim($line);
        if (strstr($line, ");")) {
          if ($j % 10 == 0)
            echo ((floor((($j) / $numberOfFiles) * 100)) . "%");
          else
            echo (".");
          $this->database->setQuery(trim($query));
          $result = $this->database->query();
          if (!$result)
            echo ("Error: " + $this->database->getQuery());
          flush();
          $query = "";
          $i++;
        }
        //	@ unlink($fileName); //try to delete
      }
    }
    echo ("100%");
  }

  function uninstall()
  {
    die("install triggered");
  }

  function activate()
  {
    $query = "UPDATE #__components SET admin_menu_img='../components/com_extrawatch/img/icons/extrawatch-logo-16x16.gif' WHERE admin_menu_link='option=com_extrawatch'";
    $this->database->setQuery(trim($query));
    $this->database->query();

    $query = "DELETE FROM #__extrawatch_config where name like 'rand' ";
    $this->database->setQuery(trim($query));
    $this->database->query();
    $query = "DELETE FROM #__components where admin_menu_link like '%option=com_extrawatch%'  and admin_menu_img like '%../components/com_extrawatch/img/icons/%' and admin_menu_img<>'../components/com_extrawatch/img/icons/extrawatch-logo-16x16.png'";
    $this->database->setQuery(trim($query));
    $this->database->query();

    $rand = rand();
    $query = "INSERT INTO #__extrawatch_config (id, name, value) values ('', 'rand', '$rand') ";
    $this->database->setQuery(trim($query));
    $this->database->query();


    $query = sprintf("select id from #__components where `name` = '%s' limit 1", "ExtraWatch");
    $this->database->setQuery(trim($query));
    $id = $this->database->loadResult();


    $query = sprintf("INSERT INTO #__components values ('', 'Live Stats', '', 0, %d, 'option=com_extrawatch', '', '', 0, '../components/com_extrawatch/img/icons/map_icon.gif', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("INSERT INTO #__components values ('', 'SEO', '', 0, %d, 'option=com_extrawatch&task=seo', '', '', 0, '../components/com_extrawatch/img/icons/seo.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Traffic Flow', '', 0, %d, 'option=com_extrawatch&task=flow', '', '', 1, '../components/com_extrawatch/img/icons/flow.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Graphs & Trends', '', 0, %d, 'option=com_extrawatch&task=graphs', '', '', 2, '../components/com_extrawatch/img/icons/trend_icon.gif', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Goals', '', 0, %d, 'option=com_extrawatch&task=goals', '', '', 3, '../components/com_extrawatch/img/icons/goal.gif', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Visit History', '', 0, %d, 'option=com_extrawatch&task=history', '', '', 4, '../components/com_extrawatch/img/icons/history.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Anti-spam & Blocking', '', 0, %d, 'option=com_extrawatch&task=antiSpam', '', '', 5, '../components/com_extrawatch/img/icons/antispam.gif', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Email Reports', '', 0, %d, 'option=com_extrawatch&task=emails', '', '', 6, '../components/com_extrawatch/img/icons/emails.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Your License', '', 0, %d, 'option=com_extrawatch&task=license', '', '', 7, '../components/com_extrawatch/img/icons/license.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Database Status', '', 0, %d, 'option=com_extrawatch&task=status', '', '', 8, '../components/com_extrawatch/img/icons/status.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Modules / Components Sizes', '', 0, %d, 'option=com_extrawatch&task=sizes', '', '', 9, '../components/com_extrawatch/img/icons/sizes.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Settings', '', 0, %d, 'option=com_extrawatch&task=settings', '', '', 10, '../components/com_extrawatch/img/icons/settings.gif', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Update', '', 0, %d, 'option=com_extrawatch&task=update', '', '', 11, '../components/com_extrawatch/img/icons/update.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
    $query = sprintf("   INSERT INTO #__components values ('', 'Credits', '', 0, %d, 'option=com_extrawatch&task=credits', '', '', 11, '../components/com_extrawatch/img/icons/credits.png', 0, '', 1)", (int) $id);
    $this->database->setQuery($query);
    $this->database->query();
  }
}


