<?php

$linesPerFile = 1700;
$path = dirname(__FILE__);
$outputFilePrefix = "extrawatch-";
$inputFileName = "ip-to-country.csv";

$inputHandle = fopen($path . DIRECTORY_SEPARATOR . $inputFileName, "rw+");
if ($inputHandle) {
    $i = 0;
    $j = 1; // starting from 1
    while (!feof($inputHandle)) {
        $buffer = fgets($inputHandle, 4096);
        if ($i % $linesPerFile == 0) {
            if (@$outputHandle) {
                fwrite($outputHandle, ";");
                fclose($outputHandle);
            }
            $outputFilename = $path . DIRECTORY_SEPARATOR . $outputFilePrefix . (int) $j . ".sql";
            echo("creating " . $outputFilename . " <br/>\n");
            $outputHandle = fopen($outputFilename, "w");
            $header = "INSERT INTO `#__extrawatch_ip2c` (`start`, `end`, `country`) VALUES \n";
            fwrite($outputHandle, $header);
            $j++;
            $i = 0;
        }
        $valuesArray = explode(";", $buffer);
        $output = "";
        if (sizeof($valuesArray) >= 3) {
            if ($i != 0 && $i < $linesPerFile) {
                $output .= ", \n";
            }
            $valuesArray[0] = str_replace("\"", "", $valuesArray[0]);
            $valuesArray[1] = str_replace("\"", "", $valuesArray[1]);
            $valuesArray[2] = str_replace("\"", "'", $valuesArray[2]);
            $output .= "(" . trim($valuesArray[0]) . ", " . trim($valuesArray[1]) . ", " . trim($valuesArray[2]) . ")";
            fwrite($outputHandle, $output);
        }
        $i++;
    }
    fwrite($outputHandle, ";");

    fclose($inputHandle);
    fclose($outputHandle);
}




