<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Statistici în timp real");
DEFINE('_EW_MENU_GOALS', "Obiective");
DEFINE('_EW_MENU_SETTINGS', "Setări");
DEFINE('_EW_MENU_CREDITS', "Atribuire");
DEFINE('_EW_MENU_FAQ', "Întrebări frecvente");
DEFINE('_EW_MENU_DOCUMENTATION', "Documentaţie");
DEFINE('_EW_MENU_LICENSE', "Licenţă");
DEFINE('_EW_MENU_DONATORS', "Suporteri");
DEFINE('_EW_MENU_SUPPORT', "Deveniţi suporter ExtraWatch şi scăpaţi de reclamele din interfaţa de administrare.");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Ultimii vizitatori");
DEFINE('_EW_VISITS_BOTS', "Roboţi");
DEFINE('_EW_VISITS_CAME_FROM', "Venit de la");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Modulul dvs. ExtraWatch nu este publicat! Noile statistici nu se înregistrează. Pentru a-l publica, mergeţi la secţiunea Module şi activaţi-l pentru toate paginile");
DEFINE('_EW_VISITS_PANE_LOADING', "Încărcare vizite...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Statisticile vizitelor pe săptămână");
DEFINE('_EW_STATS_WEEK', "Săptămână");
DEFINE('_EW_STATS_THIS_WEEK', "săptămâna aceasta");
DEFINE('_EW_STATS_UNIQUE', "unice");
DEFINE('_EW_STATS_LOADS', "încărcări");
DEFINE('_EW_STATS_HITS', "afişări");
DEFINE('_EW_STATS_TODAY', "astăzi");
DEFINE('_EW_STATS_FOR', "pentru");
DEFINE('_EW_STATS_ALL_TIME', "Toate intervalele de timp");
DEFINE('_EW_STATS_EXPAND', "mai mult");
DEFINE('_EW_STATS_COLLAPSE', "mai puţin");
DEFINE('_EW_STATS_URI', "Pagini");
DEFINE('_EW_STATS_COUNTRY', "Ţări");
DEFINE('_EW_STATS_USERS', "Utilizatori");
DEFINE('_EW_STATS_REFERERS', "Refereri");
DEFINE('_EW_STATS_IP', "IP-uri");
DEFINE('_EW_STATS_BROWSER', "Browsere");
DEFINE('_EW_STATS_OS', "Sisteme de operare");
DEFINE('_EW_STATS_KEYWORDS', "Cuvinte-cheie");
DEFINE('_EW_STATS_GOALS', "Obiective");
DEFINE('_EW_STATS_TOTAL', "Total");
DEFINE('_EW_STATS_DAILY', "Zilnic");
DEFINE('_EW_STATS_DAILY_TITLE', "Statistici zilnice");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Statistici din toate intervalele de timp");
DEFINE('_EW_STATS_LOADING', "încărcare...");
DEFINE('_EW_STATS_LOADING_WAIT', "se încarcă... vă rugăm aşteptaţi");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "Blocare IP");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Introduceţi manual IP-ul");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Introduceţi adresa IP pe care doriţi să o blocaţi (de exemplu 217.242.11.54 sau 217.* sau 217.242.* pentru a bloca toate IP-urile din categoria respectivă).");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Blocarea schimbării IP-ului pentru ");
DEFINE('_EW_STATS_PANE_LOADING', "Încărcare statistici...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Setări");
DEFINE('_EW_SETTINGS_DEFAULT', "Standard");
DEFINE('_EW_SETTINGS_SAVE', "Salvare");
DEFINE('_EW_SETTINGS_APPEARANCE', "Aspect");
DEFINE('_EW_SETTINGS_FRONTEND', "Interfaţa de vizualizare");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Istoric &amp; Performanţă");
DEFINE('_EW_SETTINGS_ADVANCED', "Avansat");
DEFINE('_EW_SETTINGS_IGNORE', "Ignorare");
DEFINE('_EW_SETTINGS_BLOCKING', "Blocare");
DEFINE('_EW_SETTINGS_EXPERT', "Expert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Sunteţi sigur că doriţi resetarea tuturor informaţiilor despre statistici şi vizitatori?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Resetare generală");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Resetarea tuturor informaţiilor despre statistici şi vizitatori");
DEFINE('_EW_SETTINGS_LANGUAGE', "Limbă");
DEFINE('_EW_SETTINGS_SAVED', "Setările au fost salvate");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Adăugaţi IP-ul dvs.");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "în listă.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Monitorizare AJAX în timp real pentru joomla");
DEFINE('_EW_BACK', "Înapoi");
DEFINE('_EW_ACCESS_DENIED', "Nu aveţi permisiunea să vizualizaţi aceste informaţii!");
DEFINE('_EW_LICENSE_AGREE', "Sunt de acord cu termenii şi condiţiile de mai sus");
DEFINE('_EW_LICENSE_CONTINUE', "Continuare");
DEFINE('_EW_SUCCESS', "Acţiune realizată cu succes");
DEFINE('_EW_RESET_SUCCESS', "Toate informaţiile despre statistici şi vizitatori au fost şterse cu succes");
DEFINE('_EW_RESET_ERROR', "Informaţiile NU au fost şterse, undeva a apărut o eroare");
DEFINE('_EW_CREDITS_TITLE', "Atribuire");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Statisticile zilnice şi săptămânale ale");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "Permisiune AJAX refuzată: Vă rugăm să vizualizaţi aceste statistici pentru domeniul specificat în configuration.php din joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Poate aţi uitat să scrieţi www. în faţa numelui de domeniu. Javascript încearcă să acceseze ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "de la");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "care este tratat ca un domeniu diferit.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Descărcaţi cea mai recentă versiune a extensiei de la");
DEFINE('_EW_HEADER_CAST_YOUR', "Vă rugăm să vă înregistraţi");
DEFINE('_EW_HEADER_VOTE', "votul");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Click pentru a afişa informaţii ajutătoare");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Plasaţi mouse-ul deasupra pentru a afişa informaţii ajutătoare");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "creşterea de ieri");
DEFINE('_EW_TOOLTIP_HELP', "Deschide ajutor online pentru");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Închideţi această fereastră");
DEFINE('_EW_TOOLTIP_PRINT', "Printează");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Introduceţi un nou obiectiv");
DEFINE('_EW_GOALS_UPDATE', "Actualizaţi numărul unui obiectiv");
DEFINE('_EW_GOALS_ACTION', "Acţiune");
DEFINE('_EW_GOALS_TITLE', "Obiectiv nou");
DEFINE('_EW_GOALS_NEW', "Obiectiv nou");
DEFINE('_EW_GOALS_RELOAD', "Reîncărcare");
DEFINE('_EW_GOALS_ADVANCED', "Avansat");
DEFINE('_EW_GOALS_NAME', "Nume");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "condiţie URI");
DEFINE('_EW_GOALS_URI_INVERSED', "condiţie inversată URI");
DEFINE('_EW_GOALS_GET_VAR', "Variabila GET");
DEFINE('_EW_GOALS_GET_CONDITION', "Condiţie GET");
DEFINE('_EW_GOALS_POST_VAR', "Variabila POST");
DEFINE('_EW_GOALS_POST_CONDITION', "Condiţie POST");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Condiţie titlu");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Condiţie nume de utilizator");
DEFINE('_EW_GOALS_IP_CONDITION', "Condiţie IP");
DEFINE('_EW_GOALS_IP_INVERSED', "Condiţie inversată IP");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Venit de la condiţia");
DEFINE('_EW_GOALS_BLOCK', "Blocare");
DEFINE('_EW_GOALS_REDIRECT', "Redirecţionare către URL");
DEFINE('_EW_GOALS_HITS', "Afişări");
DEFINE('_EW_GOALS_ENABLED', "Activat");
DEFINE('_EW_GOALS_EDIT', "Editare");
DEFINE('_EW_GOALS_DELETE', "Ştergere");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Veţi pierde toate statisticile recente pentru acest obiectiv. Sunteţi sigur că doriţi ştergerea?");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Ţări");
DEFINE('_EW_FRONTEND_VISITORS', "Vizitatori");
DEFINE('_EW_FRONTEND_TODAY', "Astăzi");
DEFINE('_EW_FRONTEND_YESTERDAY', "Ieri");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Săptămâna aceasta");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Săptămâna trecută");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Luna aceasta");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Luna trecută");
DEFINE('_EW_FRONTEND_TOTAL', "Total");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch este în modul de depanare. În acest fel puteţi descoperi cauzele erorilor. Pentru a-l opri, vă rugăm să schimbaţi valoarea EXTRAWATCH_DEBUG din /components/com_extrawatch/config.php de la 1 la 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Numărul maxim de rânduri afişate atunci când statisticile sunt în modul extins.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Toate adresele IP care înregistrează în zilele anterioare mai puţine afişări decât această valoare vor fi şterse din istoricul IP.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Toate URL-urile care înregistrează în zilele anterioare mai puţine afişări decât această valoare vor fi şterse din istoricul IP.");
DEFINE('_EW_DESC_IGNORE_IP', "Excluderea anumitor IP-uri din statistici. Separaţi-le printr-o nouă linie. Puteţi introduce aici şi categorii de IP-uri. <br/>De exemplu 192.* va ignora 192.168.51.31, 192.168.16.2, etc..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Timpul de reactualizare a vizitatorilor în milisecunde - valoarea standard este de 2000, aveţi grijă. Apoi reîncărcaţi interfaţa de administrare ExtraWatch.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Timpul de reactualizare a statisticilor în milisecunde - valoarea standard este de 4000, aveţi grijă. Apoi reîncărcaţi interfaţa de administrare ExtraWatch.");
DEFINE('_EW_DESC_MAXID_BOTS', "Numărul de vizite ale roboţilor păstrate în baza de date.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Numărul de vizite reale păstrate în baza de date.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Numărul de roboţi afişaţi în interfaţa de administrare.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Numărul de vizitatori reali afişaţi în interfaţa de administrare.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Numărul maxim de caractere afişate în titlurile lungi şi în URI-uri.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Numărul maxim de caractere afişate în secţiunea de statistici din partea dreaptă.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Numărul de zile pentru păstrarea statisticilor în baza de date, 0 = infinit.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Când vă aflaţi într-un fus orar diferit decât cel al serverului de găzduire. (valoare pozitivă sau negativă în ore)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Corectare săptămână - marcajul temporal/(3600*24*7) oferă numărul săptămânii de la 1.1.1970, aceasta este o corecţie pentru ca săptămâna să înceapă cu ziua de luni ");
DEFINE('_EW_DESC_DAY_OFFSET', "Corectare zi - marcajul temporal/(3600*24) oferă numărul zilei de la 1.1.1970, aceasta este o corecţie pentru ca ziua să înceapă la ora 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(funcţional în versiunea PRO)</b> Pentru a utiliza o iconiţă goală de 1x1px în interfaţa de vizualizare");
DEFINE('_EW_DESC_IP_STATS', "Pentru a activa statisticile adresei IP. În unele ţări este interzisă prin lege păstrarea IP-ului în baza de date pentru mai mult timp. Utilizaţi pe propriul dvs. risc.");
DEFINE('_EW_DESC_HIDE_ADS', "Această setare ascunde reclamele din interfaţa de administrare, dacă vă într-adevăr vă deranjează. Prin menţinerea lor, sprijiniţi dezvoltarea ulterioară a acestui modul. Vă mulţumim.");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Debifaţi, dacă doriţi să afişaţi informaţiile ajutătoare la poziţionarea mouse-ului deasupra, nu la click.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Valoarea implicită este 'REDIRECT_URL', care este standard dacă utilizaţi rescrierea url-urilor, poate fi schimbată în 'SCRIPT_URL' dacă se înregistrează doar index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Mesajul care este afişat utilizatorului blocat sau informaţii suplimentare despre motivul blocării respectivului utilizator.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Lăţimea secţiunii de informaţii ajutătoare");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Înălţimea secţiunii de informaţii ajutătoare");
DEFINE('_EW_DESC_TOOLTIP_URL', "Puteţi introduce orice URL aici, pentru a vizualiza IP-ul vizitatorului. Câmpul {ip} va fi înlocuit cu IP-ul vizitatorului. De exemplu http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Puteţi introduce orice URI care doriţi să fie ignorat din statistici. Puteţi utiliza wildcard-uri (* and ?). De exemplu: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Specificaţi un nume de obiectiv. Acest nume îl veţi vedea în statistici.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Orice se află după numele domeniului dvs. Pentru http://www.codegravity.com/projects/ URI-ul este: /projects/ (Exemplu de utilizat: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "Variabila GET este o variabilă pe care o puteţi vedea în URL de obicei după un semn ? sau &amp;. De exemplu http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. De asemenea puteţi utiliza <u>*</u> în acest câmp pentru a scana toate valorile get. (Exemplu de utilizat: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Aici trebuie să specificaţi o corespondenţă pentru o valoare din câmpul anterior. (Exemplu de utilizat: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Oarecum asemănător, dar verificăm valorile trimise prin formulare. Deci când aveţi un formular pe site-ul dvs., acesta are un câmp &lt;input type='text' name='<u>experiences</u>' /&gt;. (Exemplu de utilizat: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "O corespondenţă pentru valoarea din acest câmp POST. De exemplu dorim să verificăm dacă utilizatorul are sau nu experienţe de lucru în java. (Exemplu de utilizat: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Titlul unei pagini care trebuie să corespundă. (Exemplu de utilizat: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Numele unui utilizator logat. (Exemplu de utilizat: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP-ul de la care provine un utilizator: (Exemplu de utilizat: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "URL-ul de la care utilizatorul a venit. (Exemplu de utilizat: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "Utilizatorul este redirecţionat către un URL specificat de dvs. Are o prioritate mai mare decât 'blocking': (Exemplu de utilizat: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Numărul de caractere trunchiate în tabelul cu obiective");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(funcţional în versiunea PRO)</b> Backlink către codegravity.com, puteţi să îl dezactivaţi, dar vom aprecia dacă îl veţi păstra aici. Vă mulţumim.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Afişarea statisticilor totale de ţări în modulul interfeţei de vizualizare. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Dacă doriţi schimbarea ordinii pentru Vizitatori/Ţări în interfaţa de vizualizare. Prin debifare, Vizitatorii vor apărea primii.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Numărul de ţări afişate în interfaţa de vizualizare");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Afişarea ţărilor vizitatorilor în modulul interfeţei de vizualizare. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Timpul în secunde pentru a stoca extragerea totalului ţărilor în interfaţa de vizualizare");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Timpul în secunde pentru a stoca extragerea vizitatorilor în interfaţa de vizualizare");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: astăzi. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: ieri. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: săptămâna aceasta. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: săptămâna trecută. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: luna aceasta. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Pentru a afişa vizitatorii în interfaţa de vizualizare pentru: luna trecută. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Pentru a afişa numărul total de vizitatori de la instalarea ExtraWatch. Dacă este schimbată, această setare va funcţiona în interfaţa de vizualizare după timpul setat în CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Fişierul de limbă care va fi utilizat. Aceste fişiere pot fi găsite în /components/com_extrawatch/lang/. Dacă doriţi creearea unui fişier nou de limbă, verificaţi mai întâi site-ul proiectului, iar dacă nu îl puteţi găsi nici aici, pur şi simplu copiaţi english.php în german.php de exemplu şi plasaţi-l în acest folder. Apoi traduceţi toate textele din partea dreaptă.");
DEFINE('_EW_DESC_GOALS', "Obiectivele vă permit să specificaţi parametri speciali. Când aceşti parametri corespund, contorul obiectivului este incrementat. Astfel puteţi monitoriza dacă utilizatorul a vizitat un URL specific, dacă a postat o anume valoare, dacă are un nume de utilizator specific sau dacă a venit de la o anume adresă. Puteţi de asemenea bloca sau redirecţiona aceşti utilizatori către un alt URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "În toate câmpurile, cu excepţia numelui, puteţi utiliza * şi ? drept wildcard-uri. De exemplu: ?ear (va corespunde cu: near, tear, ..),  p*r (va corespunde cu: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Setaţi-l la 1, dacă doriţi ca vizitatorul să fie blocat. Acesta nu va vedea restul conţinutului, ci doar mesajul că a fost blocat, fără nici o altă redirecţionare, iar IP-ul său va fi adăugat la statisticile 'blocked' (Exemplu de utilizat: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Condiţie ţară");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "Condiţie inversată ţară");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "Codul de două litere al ţării scris cu majuscule (exemplu: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "Intern");
DEFINE('_EW_STATS_FROM', "De la");
DEFINE('_EW_STATS_TO', "La");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Adăugare la obiective");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Adăugare obiectiv pentru această ţară");
DEFINE('_EW_MENU_REPORT_BUG', "Raportare bug sau caracteristică");
DEFINE('_EW_GOALS_COUNTRY', "Ţară");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Dacă doriţi ca numele ţărilor din interfaţa de vizualizare să fie scrise cu majuscule (exemplu: GERMANIA, MAREA BRITANIE în loc de Germania, Marea Britanie)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Timpul în secunde pentru a stoca extragerea utilizatorilor în interfaţa de vizualizare");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Valoarea iniţială afişată în Total: în interfaţa de vizualizare. Utilă dacă aţi migrat de la alt modul statistic (exemplu: 20000). Setaţi înapoi la 0 dacă nu doriţi să utilizaţi această caracteristică.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignorarea utilizatorilor listaţi în această casetă de text. Câte unul pe fiecare linie (exemplu: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Cei mai activi utilizatori de astăzi dintr-un total de");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Activaţi interzicerile pe baza cuvintelor din lista de spam de mai jos?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Cele mai comune cuvinte utilizate de roboţii spam. Puteţi utiliza wildcard-uri aici, (exemplu: ph?rmac*). Dacă setarea de mai sus este activată, ExtraWatch va verifica dacă atacatorul a trimis un formular (cererea HTTP POST) pe site-ul dvs. cu câteva dintre aceste cuvinte spam. (Se aplică dacă formularul încarcă doar site-ul bazat pe Joomla - forum, comentarii, dar este destul de eficient pentru a bloca roboţii spam care încearcă să trimită orice formular posibil)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Un link pentru utilizatori în interfaţa de vizualizare - vă permite să specificaţi un URL, care se deschide când utilizatorul dă click pe numele de utilizator. Trebuie să conţină şirul de caractere {user}, care va fi înlocuit de numele propriu-zis al utilizatorului. (exemplu: index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Fraze-cheie");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Numărul maxim de valori în istoric (exemplu: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "În vizite arată doar ultima pagină accesată, nu toate");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "În vizite ascunde numele repetitiv de site în titlul paginii vizitate");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Numărul maxim de vizitatori păstraţi în baza de date pentru Istoricul vizitelor. Aveţi grijă cu această setare, dacă aveţi mult trafic, poate creşte rapid. Verificaţi întotdeauna câte informaţii conţine tabelul de istoric din Status");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Keep Database Tables on uninstall. Check this option before uninstall if you are doing an upgrade and want to keep your data.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Noaptea veţi primi emailuri cu rapoartele din ziua anterioară, pe care le puteţi citi dimineaţa");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Adresa de email la care veţi primi aceste rapoarte");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "În rapoartele prin email includeţi doar rânduri când procentul este mai mare decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "În rapoartele prin email includeţi doar schimbările <b>pozitive pe o zi</b> ale valorilor când procentul este mai mare decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "În rapoartele prin email includeţi doar schimbările <b>negative pe o zi</b> ale valorilor când procentul este mai mic decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "În rapoartele prin email includeţi doar schimbările <b>pozitive pe şapte zile</b> ale valorilor când procentul este mai mare decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "În rapoartele prin email includeţi doar schimbările <b>negative pe şapte zile</b> ale valorilor când procentul este mai mic decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "În rapoartele prin email includeţi doar schimbările <b>pozitive pe 28 de zile</b>ale valorilor când procentul este mai mare decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "În rapoartele prin email includeţi doar schimbările <b>negative pe 28 de zile</b> ale valorilor când procentul este mai mic decât {value}. Setaţi la 0 dacă nu doriţi să utilizaţi această caracteristică <i>(exemplu: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(funcţional în versiunea PRO)</b> Activaţi această setare dacă doriţi ca linkul de la logo să aibă atributul rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Numărul maxim de caractere ale numelui rândului de email. Schimbaţi această valoare dacă fereastra clientului dvs. de email este prea mică");

DEFINE('_EW_MENU_HISTORY', "Istoric");
DEFINE('_EW_MENU_EMAILS', "Emailuri");
DEFINE('_EW_MENU_STATUS', "Status bază de date");
DEFINE('_EW_DESC_BLOCKED', "Aceste IP-uri au fost blocate de anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Istoric vizitatori");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Afişează doar ultimele %d înregistrări.
                Pentru a schimba această valoare, mergeţi la Setări -&gt; Istoric &amp; Performanţă -&gt; HISTORY_MAX_DB_RECORDS . Aveţi grijă, această setare afectează timpii de încărcare a datelor de mai jos.  ");
DEFINE('_EW_MENU_BUG', "Raportare bug");
DEFINE('_EW_MENU_FEATURE', "Solicitare caracteristică");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Cuvinte-cheie");

DEFINE('_EW_BLOCKING_UNBLOCK', "deblocare");
DEFINE('_EW_STATS_KEYPHRASE ', "Fraze-cheie");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "nume tabel");
DEFINE('_EW_STATUS_DATABASE_ROWS', "rânduri");
DEFINE('_EW_STATUS_DATABASE_DATA', "date");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "total");

DEFINE('_EW_EMAIL_REPORTS', "Rapoarte prin email");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Raportul prin email generat şi filtrat de ieri");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Filtre valoare email");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "valoare");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "procent");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "schimbare pe o zi");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "schimbare pe şapte zile");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "schimbare pe 28 de zile");
DEFINE('_EW_ANTISPAM_BLOCKED', "Astăzi ExtraWatch a blocat %d afişări spam, total: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Adrese IP blocate");
DEFINE('_EW_ANTISPAM_SETTINGS', "Setări Anti-Spam");
DEFINE('_EW_TRAFFIC_AJAX', "AJAX actualizează traficul (cu excepţia hărţilor)");


DEFINE('_EW_HISTORY_PREVIOUS', "înapoi");
DEFINE('_EW_HISTORY_NEXT', "înainte");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Numărul de coloane pentru ţări");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Numărul de rânduri pentru ţări");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Afişaţi sau nu numele ţărilor");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Afişaţi mai întâi steagurile, apoi procentele");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "Condiţie inversată GET");
DEFINE('_EW_GOALS_POST_INVERSED', "Condiţie inversată POST");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Condiţie inversată titlu");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Condiţie inversată nume de utilizator");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Venit de la condiţia inversată");

DEFINE('_EW_STATS_MAP', "Harta ultimelor vizite");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Vă rugăm să introduceţi cheia <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> pentru a afişa harta ultimelor vizite:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "salvare cheie");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Vă rugăm să introduceţi o cheie ipinfodb validă obţinută de la: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "CERERE GREŞITĂ: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Câmpuri de formular trimise:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "Parametri URL:");
DEFINE('_EW_VISIT_ADD_PAGE', " Adaugare pagină ca obiectiv");
DEFINE('_EW_VISIT_BLOCK_IP', " Blocarea acestei adrese IP");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Adăugarea acestei variabile din formular ca obiectiv");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Adăugarea acestui parametru URL ca obiectiv");

DEFINE('_EW_TREND_EMPTY', "Empty");

DEFINE('_EW_NOT_NUMBER', " ATENŢIE: Valoarea introdusă nu este un număr. ExtraWatch nu va funcţiona corespunzător!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Aceasta este o versiune de evaluare pentru 15 zile. Zile rămase: <b>%d</b>. Vă rugăm să cumpăraţi <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>licenţa nelimitată ExtraWatch pentru domeniul dvs.</a> a acestei versiuni şi a celor următoare.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Versiunea dvs. de evaluare a expirat. Vă rugăm să cumpăraţi ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Licenţă activată cu succes. Vă mulţumim.");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Eroare: cheia de licenţă nu corespunde cu domeniul dvs.</b><br/>Aţi introdus acelaşi nume de domeniu în formularul de donaţie ca şi cel pe care îl vedeţi mai jos? <br/>Click pe '<b>request the correct activation key</b>' de mai jos, sau contactaţi-ne la: info@codegravity.com<br/>");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Dacă mesajul de mai sus este afişat prea mult, statisticile dvs. în timp real ar putea fi greşite.
                    Deschideţi components/com_extrawatch/config.php
                    decomentaţi şi setaţi site-ul dvs. propriu-zis. De exemplu:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Atenţie: site-ul din browser şi site-ul din configurare: %s şi %s nu corespund.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Setaţi site-ul către: %s şi continuaţi...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Ştergeţi backlink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Baza de date cu informaţii ajutătoare");
DEFINE('_EW_ADMINHEADER_FLOW', "Flux");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Grafice");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Componente");
DEFINE('_EW_ADMINHEADER_REVIEW', "Recenzie");
DEFINE('_EW_ADMINHEADER_WRITE', "Scrieţi o ");

DEFINE('_EW_FLOW_TRAFFIC', "Flux de trafic");
DEFINE('_EW_FLOW_SELECT_PAGE', "Selectare pagină:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Contor linkuri externe:");
DEFINE('_EW_FLOW_NESTING', "Nivel nesting:");
DEFINE('_EW_FLOW_SCALE', "Scală:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Versiunea fără reclame");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Vă mulţumim mult pentru donaţia făcută!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Cheia de înregistrare pentru domeniul dvs. %s este: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Acum puteţi şterge backlink-ul sau ascunde logo-ul ExtraWatch în interfaţa de vizualizare din Setări ");


DEFINE('_EW_SIZES_LAST_CHECK', "Ultima verificare a fost făcută pe:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Mărimea componentei/modulului în folderul /administrator");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Componentă");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Total:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Mărime");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Reactualizarea tuturor");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabel");
DEFINE('_EW_SIZEDATABASE_SIZE', "Mărime");
DEFINE('_EW_SIZEDATABASE_1DAY', "schimbare pe o zi");
DEFINE('_EW_SIZEDATABASE_7DAY', "schimbare pe şapte zile");
DEFINE('_EW_SIZEDATABASE_28DAY', "schimbare pe 28 de zile");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "nu există date");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Total:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Reactualizarea tuturor");
DEFINE('_EW_SIZEMODULES_TOTAL', "Total:");
DEFINE('_EW_SIZEMODULES_MODULE', "Modul");
DEFINE('_EW_SIZEMODULES_SIZE', "Mărime");

DEFINE('_EW_SIZES_FILES', "Fişiere &amp; Foldere");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Reactualizare");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "Mărimile tabelelor din baza de date");


DEFINE('_EW_DESC_IPINFODB_KEY', "Ultima cheie ipinfodb.com pentru harta vizitelor de la: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Forţarea corectării fusului orar");


/* ExtraWatch 1.2.17 translations */

DEFINE('_EW_MENU_UPDATE', "Actualizare");
DEFINE('_EW_MENU_UPDATE_TITLE', "Backup & Actualizare");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Nu este disponibil în versiunea gratuită, vă rugăm să verificaţi secţiunea de licenţă");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Activarea banării cuvintelor spam");
DEFINE('_EW_SPAMWORD_LIST', "Lista cuvintelor spam");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Ascunderea titlului repetitiv");
DEFINE('_EW_TRUNCATE_VISITS', "Trunchiere vizite");
DEFINE('_EW_TRUNCATE_STATS', "Trunchiere statistici");
DEFINE('_EW_TRUNCATE_GOALS', "Trunchiere obiective");
DEFINE('_EW_LIMIT_BOTS', "Limitare roboţi");
DEFINE('_EW_LIMIT_VISITORS', "Limitare vizitatori");
DEFINE('_EW_TOOLTIP_WIDTH', "Lăţimea secţiunii de informaţii ajutătoare");
DEFINE('_EW_TOOLTIP_HEIGHT', "Înălţimea secţiunii de informaţii ajutătoare");
DEFINE('_EW_TOOLTIP_URL', "URL-ul secţiunii de informaţii ajutătoare");
DEFINE('_EW_TOOLTIP_ONCLICK', "Secţiune de informaţii ajutătoare de tip OnClick");
DEFINE('_EW_IP_STATS', "Statistici IP");
DEFINE('_EW_IPINFODB_KEY', "Cheie IP Info DB ");
DEFINE('_EW_ONLY_LAST_URI', "Doar ultimul URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Ascundere logo în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "No Follow în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Fără Back Link în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_USER_LINK', "Linkuri utilizator în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Mai întâi ţările în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Nume ţări în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Majuscule ţări în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Mai întâi steagul ţărilor în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Număr ţări în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Numărul maxim de coloane pentru ţări în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Numărul maxim de rânduri pentru ţări în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Vizitatorii de astăzi în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Vizitatorii de ieri în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Vizitatorii de săptămâna aceasta în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Vizitatorii de săptămâna trecută în interfaţa de vizualizare ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Vizitatorii de luna aceasta în interfaţa de vizualizare ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Vizitatorii de luna trecută în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Ascundere total vizitatori în interfaţa de vizualizare");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Total iniţial în interfaţa de vizualizare");
DEFINE('_EW_HISTORY_MAX_VALUES', "Numărul maxim de valori din istoric");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Numărul maxim de înregistrări din istoric");
DEFINE('_EW_UPDATE_TIME_VISITS', "Actualizare timp vizite");
DEFINE('_EW_UPDATE_TIME_STATS', "Actualizare statistici de timp");
DEFINE('_EW_STATS_MAX_ROWS', "Numărul maxim de rânduri ale statisticilor");
DEFINE('_EW_STATS_IP_HITS', "Statistici afişări IP");
DEFINE('_EW_MAXID_BOTS', "Numărul maxim de ID-uri roboţi");
DEFINE('_EW_MAXID_VISITORS', "Numărum maxim de ID-uri vizitatori");
DEFINE('_EW_STATS_KEEP_DAYS', "Numărul de zile pentru păstrarea statisticilor ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Stocare ţări în interfaţa de vizualizare ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Stocare vizitatori în interfaţa de vizualizare ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Dezinstalare păstrare date ");
DEFINE('_EW_IGNORE_IP', "Ignorare IP");
DEFINE('_EW_IGNORE_URI', "Ignorare URI");
DEFINE('_EW_IGNORE_USER', "Ignorare utilizator");
DEFINE('_EW_BLOCKING_MESSAGE', "Blocare mesaj");
DEFINE('_EW_SERVER_URI_KEY', "Cheie server URI");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Total iniţial vizitatori în interfaţa de vizualizare");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Înregistrări");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Pentru ca blocarea să aibă efect, trebuie să publicaţi agentul ExtraWatch ÎNAINTE de orice conţinut sau formulare. De exemplu în partea stângă a template-ului dvs.
                    <br/>
                    Mergeţi la Module Manager -> ExtraWatch agent -> selectaţi poziţia la stânga");

DEFINE('_EW_EMAIL_SEO_REPORTS', "Rapoarte SEO");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "Rapoarte SEO prin email trimis noaptea, activate");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Vizualizaţi demo instalare");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
