<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch: Estonian language - Eesti.keel

// Main Menu.
DEFINE('_EW_MENU_STATS', "Live statistika");
DEFINE('_EW_MENU_GOALS', "Eesmärgid");
DEFINE('_EW_MENU_SETTINGS', "Seaded");
DEFINE('_EW_MENU_CREDITS', "Autorid");
DEFINE('_EW_MENU_FAQ', "KKK");
DEFINE('_EW_MENU_DOCUMENTATION', "Dokumentatsioon");
DEFINE('_EW_MENU_LICENSE', "Litsents");
DEFINE('_EW_MENU_DONATORS', "Toetajad");
DEFINE('_EW_MENU_SUPPORT', "Toeta ExtraWatch'i ja sa saad oma reklaamid eemaldada administraatori lehel.");

// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Viimased külastajad");
DEFINE('_EW_VISITS_BOTS', "Robotid");
DEFINE('_EW_VISITS_CAME_FROM', "Tuli");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Sinu ExtraWatch moodul ei ole avaldatud! Uusi andmeid ei salvestata, et seda avaldada, mine Moodulite sektsiooni ja avalda see kõikidel lehtedel");
DEFINE('_EW_VISITS_PANE_LOADING', "Laen külastusi...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Nädala külastuste statistika");
DEFINE('_EW_STATS_WEEK', "Nädal");
DEFINE('_EW_STATS_THIS_WEEK', "sel nädalal");
DEFINE('_EW_STATS_UNIQUE', "unikaalne");
DEFINE('_EW_STATS_LOADS', "laadimist");
DEFINE('_EW_STATS_HITS', "tabamust");
DEFINE('_EW_STATS_TODAY', "täna");
DEFINE('_EW_STATS_FOR', "");
DEFINE('_EW_STATS_ALL_TIME', "Kokku");
DEFINE('_EW_STATS_EXPAND', "Laienda");
DEFINE('_EW_STATS_COLLAPSE', "Ahenda");
DEFINE('_EW_STATS_URI', "lehed");
DEFINE('_EW_STATS_COUNTRY', "Riigid");
DEFINE('_EW_STATS_USERS', "kasutajad");
DEFINE('_EW_STATS_REFERERS', "linkijad");
DEFINE('_EW_STATS_IP', "IPd");
DEFINE('_EW_STATS_BROWSER', "brauserid");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "märksõnad");
DEFINE('_EW_STATS_GOALS', "Eesmärgid");
DEFINE('_EW_STATS_TOTAL', "Kokku");
DEFINE('_EW_STATS_DAILY', "Täna");
DEFINE('_EW_STATS_DAILY_TITLE', "Päeva statistika");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Kogu statistika");
DEFINE('_EW_STATS_LOADING', "laadimine...");
DEFINE('_EW_STATS_LOADING_WAIT', "laadimine... palun oota");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "IP blokeerimine");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Sisesta IP käsitsi");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Sisesta IP aadress, mida soovid blokeerida. (nt 217.242.11.54 või 217.* või 217.242.*, et blokeerida kõik IPd, mis sobivad nende märkidega)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Blokeeri järgmine IP: ");
DEFINE('_EW_STATS_PANE_LOADING', "Laen andmeid...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Seaded");
DEFINE('_EW_SETTINGS_DEFAULT', "Vaikeseaded");
DEFINE('_EW_SETTINGS_SAVE', "Salvesta");
DEFINE('_EW_SETTINGS_APPEARANCE', "Välimus");
DEFINE('_EW_SETTINGS_FRONTEND', "Esileht");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Ajalugu &amp; jõudlus");
DEFINE('_EW_SETTINGS_ADVANCED', "Täpsemalt");
DEFINE('_EW_SETTINGS_IGNORE', "Eira");
DEFINE('_EW_SETTINGS_BLOCKING', "Blokeerimine");
DEFINE('_EW_SETTINGS_EXPERT', "Ekspert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Kas sa tõesti soovid nullida kogu statistika ja külastajate andmed?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Taasta kõik");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Nulli kogu statistika &amp; külastajate andmed");
DEFINE('_EW_SETTINGS_LANGUAGE', "Keel");
DEFINE('_EW_SETTINGS_SAVED', "Seaded on salvestatud");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Lisa oma IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "nimekirja.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Reaalajas AJAX Joomla jälgija");
DEFINE('_EW_BACK', "Tagasi");
DEFINE('_EW_ACCESS_DENIED', "Sul ei ole õigusi selle lehe vaatamiseks!");
DEFINE('_EW_LICENSE_AGREE', "Nõustun tingimustega, mis on eespool");
DEFINE('_EW_LICENSE_CONTINUE', "Jätka");
DEFINE('_EW_SUCCESS', "Toiming oli edukas");
DEFINE('_EW_RESET_SUCCESS', "Kogu statistika ja külastajate andmed kustutati edukalt");
DEFINE('_EW_RESET_ERROR', "Andmed EI kustutatud edukalt, midagi läks viltu");
DEFINE('_EW_CREDITS_TITLE', "Autorid");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Igapäeva ja iganädala statistika");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX juurdepääs keelatud: Palun vaata seda statistikat domeenist, mis on nimetatud configuration.php joomla failis - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Võibolla sa lihtsalt unustasid www. oma domeeni nime ette panemast. Teie javascript püüab kasutada ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "Mis teeb seda arvama, et see on erinev domeen.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Hangi pikendus kood");
DEFINE('_EW_HEADER_CAST_YOUR', "Sisesta oma");
DEFINE('_EW_HEADER_VOTE', "hääl");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Vajuta, et näha kohtspikrit");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Hõlju hiirega üle, et näha kohtspikrit");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "eilne kasv");
DEFINE('_EW_TOOLTIP_HELP', "Avab online välise abi");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Sulge see aken");
DEFINE('_EW_TOOLTIP_PRINT', "Prindi");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Sisesta uus eesmärk");
DEFINE('_EW_GOALS_UPDATE', "Update eesmärki nr");
DEFINE('_EW_GOALS_ACTION', "Toiming");
DEFINE('_EW_GOALS_TITLE', "Uus eesmärk");
DEFINE('_EW_GOALS_NEW', "Uus eesmärk");
DEFINE('_EW_GOALS_RELOAD', "Värskenda");
DEFINE('_EW_GOALS_ADVANCED', "Täpsem");
DEFINE('_EW_GOALS_NAME', "Nimi");
DEFINE('_EW_GOALS_ID', "ID");
DEFINE('_EW_GOALS_URI_CONDITION', "URI tingimus");
DEFINE('_EW_GOALS_URI_INVERSED', "URI ümberpööramis tingimus");
DEFINE('_EW_GOALS_GET_VAR', "GET var");
DEFINE('_EW_GOALS_GET_CONDITION', "GET tingimus");
DEFINE('_EW_GOALS_POST_VAR', "POST Var");
DEFINE('_EW_GOALS_POST_CONDITION', "POST tingimus");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Pealkirja tingimus");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Kasutaja tingimus");
DEFINE('_EW_GOALS_IP_CONDITION', "IP tingimus");
DEFINE('_EW_GOALS_IP_INVERSED', "IP ümberpööramis tingimus");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Tuli tingimus");
DEFINE('_EW_GOALS_BLOCK', "Blokeeri");
DEFINE('_EW_GOALS_REDIRECT', "Suuna ümber URLile");
DEFINE('_EW_GOALS_HITS', "Tabamused");
DEFINE('_EW_GOALS_ENABLED', "Sees");
DEFINE('_EW_GOALS_EDIT', "Muuda");
DEFINE('_EW_GOALS_DELETE', "Kustuta");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Sa kaotad selle eesmärgi kõik hiljutised statistika andmed. Kas sa tõesti soovid kustutada eesmärki nr ");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Riigid");
DEFINE('_EW_FRONTEND_VISITORS', "Külastajad");
DEFINE('_EW_FRONTEND_TODAY', "Täna");
DEFINE('_EW_FRONTEND_YESTERDAY', "Eile");
DEFINE('_EW_FRONTEND_THIS_WEEK', "See nädal");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Eelmine nädal");
DEFINE('_EW_FRONTEND_THIS_MONTH', "See kuu");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Eelmine kuu");
DEFINE('_EW_FRONTEND_TOTAL', "Kokku");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch on silumis režiimis. Sel moel saab leida vigade põhjuseid. Et see välja lülitada, palun muuda EXTRAWATCH_DEBUG /components/com_extrawatch/config.php väärtust. Muuda 1 tagasi 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Max rida, mida näidatakse, kui statistika on laiendatud režiimis.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Kõikidel IP aadressidel, millel on vähem tabamusi eelmistel päevadel, kui sellel väärtusel siis kustutatakse see IP ajaloost.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Kõikidel URL-idel aadressidel, millel on vähem tabamusi eelmistel päevadel, kui sellel väärtusel siis kustutatakse see IP ajaloost.");
DEFINE('_EW_DESC_IGNORE_IP', "Välista teatud IP aadressid statistikast. Eralda uue reaga. Võid kasutada ka metamärke siin. <br/>Nt. 192.* ignoreerib 192.168.51.31, 192.168.16.2, jne.");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Külastajate värskendamis aeg millisekundites, vaikeseade on 2000, ole sellega ettevaatlik. Siis lae uuesti ExtraWatch administraatori lehte.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Statistika värskendamis aeg millisekundites, vaikeseade on 4000, ole sellega ettevaatlik. Siis lae uuesti ExtraWatch administraatori lehte.");
DEFINE('_EW_DESC_MAXID_BOTS', "Mitu roboti külastust hoitakse andmebaasis.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Mitu päris külastajat hoitakse andmebaasis.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Mitu roboti sa näed administraatori lehel.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Kui palju päris külastajaid sa näed administraatori lehel.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Maksimaalne tähemärkide arv, mida näidatakse pikemates pealkirjades ja linkides.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Maksimaalne tähemärkide arv, mida näidatakse paremal olevas statistika paneelis.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Mitu päeva hoitakse statistikat andmebaasis, 0 = lõpmatu.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Kui oled erinevas ajav&ouml;&ouml;ndis, kui oma server. (positiivne või negatiivne väärtus tunnis)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Nädala nihe, ajatempel/(3600*24*7) annab nädala numbri alates 1.1.1970, see nihe on parandus, mis paneb seda alustama esmaspäevast ");
DEFINE('_EW_DESC_DAY_OFFSET', "Päeva nihe, ajatempel/(3600*24) annab päeva numbri alates 1.1.1970, see nihe on parandus, mis paneb seda alustama kell 00:00 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(funktsionaalne reklaami-vaba versioonis)</b> Kasutatakse 1x1px ikooni esilehel");
DEFINE('_EW_DESC_IP_STATS', "Selleks, et lülitada sisse IP-aadressi statistikat. Mõnes riigis IP andmebaasi hoidmine pikemat aega on keelatud seadusega. Kasuta omal vastutusel.");
DEFINE('_EW_DESC_HIDE_ADS', "See seade peidab reklaami administraatori lehel, kui see tõesti sind tüütab. Hoides neid, te toetate selle t&ouml;&ouml;riista edasiarendamist. Tänan teid");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Eemalda, kui soovid kuvada kohtspikrit hiire üle minnes, hiireklõpsuga avamise asemel.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Vaikeseade on 'REDIRECT_URL', mis on standard, kui sa kasutad URL ümberkirjutamist, saab seada ka 'SCRIPT_URL' kui see logib ainult index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Sõnum, mida näidatakse blokeeritud kasutajale või täiendavat teavet, miks sa blokeerid neid kasutajaid.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Kohtspikri laius");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Kohtspikri kõrgus");
DEFINE('_EW_DESC_TOOLTIP_URL', "Sa võid panna siia ükskõik millise URLi, et visualiseerida külastaja IPd. {ip} asendatakse külastaja IPga. Nt. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Siia võid kirjutada IP aadressid, mida eiratakse statistikas. Võid kasutada ka metamärke (* ja ?). Nt.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Täpsusta eesmärgi nimi. Seda nime näed statistikas.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Kõik, mis on pärast sinu domeeninime. http://www.codegravity.com/projects/ URLi jaoks on /projects/ (Kasutammis näide: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET muutuja on muutuja, mida näed URLis tavaliselt pärast ? või &amp; märki. Nt. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Sa võid ka kasutada <u>*</u> selles väljas, et kontrollida kõiki GET väärtusi. (Kasutammis näide: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Siin tuleb sul määrata vaste eelmise välja väärtusele. (Kasutammis näide: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "üsna sarnane, kuid me kontrollimine väärtusi, mis on esitatud vormist. Nii, et kui sul on vorm oma veebilehel, millel on väli &lt;input type='text' name='<u>experiences</u>' /&gt;. (Kasutammis näide: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Vaste väärtus sellest POST väljast. Nt. me tahame kontrollida, kas kasutajatel on java kogemusi. (Kasutammis näide: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Lehe pealkiri, mis peab sobima. (Kasutammis näide: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Sisseloginud kasutaja nimi. (Kasutammis näide: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP kust kasutaja tuleb: (Kasutammis näide: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "URL kust kasutaja tuleb. (Kasutammis näide: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "Kasutaja suunatakse URLile, mille oled määranud. Sellel on suurem prioriteet, kui 'blocking': (Kasutammis näide: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Mitu tähemärki kärbitakse eesmärkide tabelis");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(funktsionaalne reklaami-vaba versioonis)</b> codegravity.com link, võid selle välja lülitada, kuid me oleme tänulik kui see on seal. Tänan teid");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Näita riikide statistikat esilehel olevas moodulis. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Kui sa soovid vahetada külastajate/riikide järjekorda esilehel. Eemalda see valik ja Külastajad ilmuvad esimesena.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Mitu riiki näidatakse esilehel.");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Näita riikide külastajaid esilehel olevas moodulis. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud in CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Aeg sekundites, kuni vahemälu võetakse esilehel olevatel riikidel");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Aeg sekundites, kuni vahemälu võetakse esilehel olevatel külastajatel");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Selleks, et näidata külastajaid esilehel: täna. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Selleks, et näidata külastajaid esilehel: eile. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Selleks, et näidata külastajaid esilehel: sellel nädalal. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Selleks, et näidata külastajaid esilehel: eelmisel nädalal. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Selleks, et näidata külastajaid esilehel: sellel kuul. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Selleks, et näidata külastajaid esilehel: eelmisel kuul. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Selleks, et näidata külastajate koguarvu alates ExtraWatch'i paigaldamisest. Kui muudetud, see funktsioon hakkab esilehel t&ouml;&ouml;le pärast tähtaega, mis on sätestatud CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Kasutatav keelefail. Nad on paigutatud /components/com_extrawatch/lang/. Kui soovid luua täiesti uut keele fail, kontrollige kõigepealt projekti kodulehte, ja kui keele fail ei ole ikka veel olemas, kopeeri vaike keele fail english.php ja muuda see nt german.php ja pane see sinna kataloogi. Siis, tõlki kõik failis olevad olulisemad väärtused.");
DEFINE('_EW_DESC_GOALS', "Eesmärkidega saad määrata eri parameetreid. Kui need parameetrid langevad kokku, eesmärgi loendur suureneb. Nii saad jälgida, kas kasutaja on külastanud konkreetset URLi, postitanud konkreetse väärtuse, on eriline kasutajanime või tuli konkreetselt aadressilt. SA saad ka blokeerida või suunata selliseid kasutajaid mõnele teisele URLile.");
DEFINE('_EW_DESC_GOALS_INSERT', "Kõikides valdkondades, välja arvatud nimi saad kasutada * ja ? metamärke. Nagu näiteks: ?ear (sobib kokku: near, tear, ...),  p*r (sobib kokku: pr, peer, pear ...) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Määra väärtuseks 1 kui sa soovid kasutajaid blokeerida. Ta ei näe ülejäänud sisu, ainult sõnumi, et ta on blokeeritud - ilma ümbersuunamiseta ja tema IP on lisatud 'blokeeritud' statistikasse (Kasutammis näide: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Riigi olukord");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "Riigi ümberpööramis tingimus");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2-täheline riigi kood suurtes tähtedes (nt: <b>EE</b>)");
DEFINE('_EW_STATS_INTERNAL', "Sisemine");
DEFINE('_EW_STATS_FROM', "Kust");
DEFINE('_EW_STATS_TO', "Kuhu");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Lisa eesmärkide hulka");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Lisa eesmärk sellele riigile");
DEFINE('_EW_MENU_REPORT_BUG', "Teata veast või funktsioonist");
DEFINE('_EW_GOALS_COUNTRY', "Riik");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Kui soovid esilehel riigi nimesid suurtes tähtedes (Nt: SAKSAMAA ja SUURBRITANNIA. Saksamaa ja Suurbritannia asemel.)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Aeg sekundites, kuni vahemälu võetakse esilehel olevatel kasutajatelt");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Esialgne väärtus, mida näidatakse kokku: esilehel. Kasulik, kui sa migreerud teise statistika komponenti. (Nt.: 20000). Muuda väärtus tagasi 0 kui sa ei soovi seda funktsiooni kasutada.");
DEFINE('_EW_DESC_IGNORE_USER', "Eira kasutajad, kes on loetletud selles tekstikastis, üks rea kohta. (Nt: Mina {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Kõige aktiivsemad kasutajad täna");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Luba keelud, mis põhineb allpool olevatest spämmi sõnadest? ?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Kõige levinumad rämpsposti sõnad, mida kasutavad spämmi robotid. Võid kasutada ka metamärke siin, (Nt.: ph?rmac*). Kui see seade on sisse lülitatud, ExtraWatch kontrollib, kas ründaja sisestas välja (HTTP POST-taotluse) sinu veebilehel, mis sisaldavad neid spämmi sõnu. (Rakendub juhul kui vorm laeb Joomla baasil olevas veebilehel ainult - foorum, kommentaarid, kuid see on üsna tõhus viis blokeerimaks spämmi roboteid, mis püüavad sisestada igat võimaliku vormi.)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Rämpspostitõrje");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Link esilehel olevas Kasutaja moodulis - võimaldab määrata URLi, mis avaneb, kui kasutaja klõpsab kasutaja nimi. Peab sisaldama stringi {user}, mis asendatakse tegeliku kasutaja nimega. (Nt. index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "võtmelaused");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Maksimumväärtus ajaloo vahelehel (Näide: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "Külastuses näita ainult viimast külastatud lehte, mitte kõiki");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "Külastustes peida korduvad lehenimed, külastatud lehe pealkirjas");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Maksimum number külastajaid, mida hoitakse külastajate ajaloo andmebaasis. Ole selle seadega ettevaatlik, kui teil on kõrge liiklus siis võib see kasvada väga kiiresti. Kontrolli alati, kui palju andmeid ajaloo statistika tabelis on");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Hoia andmebaasi tabelid komponendi eemaldamisel. Märgi see valik, enne eemaldamist, kui sa teostad versiooniuuendust ja soovid oma andmeid hoida.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Sa saad &ouml;&ouml;sel e-posti aruandeid eelmise päeva kohta, mida sa võid hommikul lugeda");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "E-posti aadress, kuhu saadetakse need aruanded");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Ainult lisa read e-posti aruandes, kus see protsent on kõrgem kui {value}. Määra see 0 kui sa ei soovi seda funktsiooni kasutada <i>(näide: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Ainult kaasa <b>positiivne üks päev</b> muuda väärtus e-maili aruandesse, mis on suurem kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Ainult kaasa <b>negatiivne üks päev</b> muuda väärtus e-maili aruandesse, mis on madalam kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Ainult kaasa <b>positiivne seitse päeva</b> muuda väärtus e-maili aruandesse, mis on suurem kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Ainult kaasa <b>negatiivne seitse päeva</b> muuda väärtus e-maili aruandesse, mis on madalam kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Ainult kaasa <b>positiivne kolmkümmend päeva</b> muuda väärtus e-maili aruandesse, mis on suurem kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Ainult kaasa <b>negatiivne kolmkümmend päeva</b> muuda väärtus e-maili aruandesse, mis on madalam kui {value} protsent. Määra väärtuseks 0, kui sa ei soovi seda funktsiooni kasutada <i>(näide: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(funktsionaalne reklaami-vaba versioonis)</b> Lülita sisse see seade, kui soovid muuta logo lingi atribuuti rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Maksimaalne tähemärkide arv e-posti rea nimes. Muuda seda, kui sinu e-posti sõnumi aken on liiga väike");

DEFINE('_EW_MENU_HISTORY', "Ajalugu");
DEFINE('_EW_MENU_EMAILS', "Emailid");
DEFINE('_EW_MENU_STATUS', "AB olek");
DEFINE('_EW_DESC_BLOCKED', "Need IPd on blokeerinud rämpspostitõrje");


DEFINE('_EW_HISTORY_VISITORS', "Külastajate ajalugu");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Näidatakse ainult %d viimast külastajat.
                Selle väärtuse muutmiseks, mine Seaded -&gt; Ajalugu &amp; Jõudlus -&gt; HISTORY_MAX_DB_RECORDS . Ole ettevaatlik, see seade mõjutab allpool olevate andmete laadimisaega.  ");
DEFINE('_EW_MENU_BUG', "Teata veast");
DEFINE('_EW_MENU_FEATURE', "Küsi funktsiooni");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Märksõnad");

DEFINE('_EW_BLOCKING_UNBLOCK', "deblokeeri");
DEFINE('_EW_STATS_KEYPHRASE ', "Võtme lause");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "tabeli nimi");
DEFINE('_EW_STATUS_DATABASE_ROWS', "rida");
DEFINE('_EW_STATUS_DATABASE_DATA', "andmed");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "kokku");

DEFINE('_EW_EMAIL_REPORTS', "Emaili aruanded");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Eile loodud filtreeritud e-posti aruanne");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Emaili väärtuse filtrid");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "väärtus");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "protsent");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "1-päeva muutus");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "7-päeva muutus");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "28-päeva muutus");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch on blokeerinud %d spämmerit täna, kokku: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Blokeeritud IP aadressid");
DEFINE('_EW_ANTISPAM_SETTINGS', "Rämpspostitõrje seaded");
DEFINE('_EW_TRAFFIC_AJAX', "AJAX värskendab liiklusteavet");


DEFINE('_EW_HISTORY_PREVIOUS', "tagasi");
DEFINE('_EW_HISTORY_NEXT', "edasi");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Riikide veergude arv");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Riikide ridade arv");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Näita või ära näita riikide nimesid");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Näita lippe ennem, seejärel protsente");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "GET ümberpööramis tingimus");
DEFINE('_EW_GOALS_POST_INVERSED', "POST ümberpööramis tingimus");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Tiitli ümberpööramis tingimus");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Kasutajanime ümberpööramis tingimus");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Tuli ümberpööramis tingimus");

DEFINE('_EW_STATS_MAP', "Viimaste külastuste kaart");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Palun sisesta <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> võti, et kuvada viimaste külastuste kaarti:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "säilita võti");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Palun sisesta kehtiv ipinfodb võti, mille said lehelt: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "HALB PÄRING: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Sisestatud vormiväljad:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URL parameetrid:");
DEFINE('_EW_VISIT_ADD_PAGE', " Lisa leht eesmärgina");
DEFINE('_EW_VISIT_BLOCK_IP', " Blokeeri see IP aadress");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Lisa see sisestatud vormi muutuja eesmärgina");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Lisa see URL parameeter eesmärgina");

DEFINE('_EW_TREND_EMPTY', "Tühi");

DEFINE('_EW_NOT_NUMBER', " HOIATUS: Sisestatud väärtus ei ole number. ExtraWatch ei tööta korralikult!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; See on 15-päevane testimise versioon. Päeva jäänud: <b>%d</b>. Palun osa eluaegne <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch litsents oma domeenile</a> sellele ja tulevastele versioonidele.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Sinu prooviversioon on aegunud. Palun osta ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Litsents on aktiveeritud edukalt. Tänan teid");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Tõrge: litsentsivõti ja domeen ei sobi.</b><br/>Kas sa sisestasid sama domeeninime annetuse vormis, mida näed allpool? Palun võta ühendust: info@codegravity.com");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Kui sa näed eespool olevat sõnumit liiga kaua siis sinu live sait võib olla vale.
                    Ava components/com_extrawatch/config.php
                    eemalda kommentaar ja määra oma tegelik live sait. nt:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Hoiatus: Sinu brauseris olev sait ja live sait konfiguratsioonis: %s ja %s ei sobi.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Määra live sait: %s ja jätka...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Eemalda tagalink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Teadmistebaas");
DEFINE('_EW_ADMINHEADER_FLOW', "Voog");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Graafik");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Komponendid");
DEFINE('_EW_ADMINHEADER_REVIEW', "ülevaade");
DEFINE('_EW_ADMINHEADER_WRITE', "Kirjuta ");

DEFINE('_EW_FLOW_TRAFFIC', "Liiklusvoog");
DEFINE('_EW_FLOW_SELECT_PAGE', "Vali leht:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Juure väljuvate linkide arv:");
DEFINE('_EW_FLOW_NESTING', "Pesastustase:");
DEFINE('_EW_FLOW_SCALE', "Skaala:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Reklaamivaba versioon");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Täname Teid väga Teie annetuse eest!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Sinu domeeni %s registreerimisvõti on: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Nüüd sa saad eemaldada tagalinki või peita ExtraWatch logo esilehel (seadetes) ");


DEFINE('_EW_SIZES_LAST_CHECK', "Viimane kontroll teostati:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "SININE = Komponendi/mooduli suurus /administrator kataloogis");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Komponent");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Kokku:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Suurus");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Värskenda kõik");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabel");
DEFINE('_EW_SIZEDATABASE_SIZE', "Suurus");
DEFINE('_EW_SIZEDATABASE_1DAY', "1 päeva muutus");
DEFINE('_EW_SIZEDATABASE_7DAY', "7 päeva muutus");
DEFINE('_EW_SIZEDATABASE_28DAY', "30 päeva muutus");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "andmed puuduvad");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Kokku:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Värskenda kõiki");
DEFINE('_EW_SIZEMODULES_TOTAL', "Kokku:");
DEFINE('_EW_SIZEMODULES_MODULE', "Moodul");
DEFINE('_EW_SIZEMODULES_SIZE', "Suurus");

DEFINE('_EW_SIZES_FILES', "Failid &amp; kataloogid");
DEFINE('_EW_SIZES_BYTES', "baiti");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Värskenda");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "Joomla andmebaasi tabeli suuruss");


DEFINE('_EW_DESC_IPINFODB_KEY', "Viimaste külastuste kaart ipinfodb.com võti: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Sunni ajatsooni nihe");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Uuenda");
DEFINE('_EW_MENU_UPDATE_TITLE', "Varunda & Uuenda");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Pole saadaval tasuta versioonis, kontrolli palun litsentsi vahekaarti");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Spämmi sõnade keeld lubatud");
DEFINE('_EW_SPAMWORD_LIST', "Spämmi sõnade nimekiri");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Peida korduvad pealkirjad");
DEFINE('_EW_TRUNCATE_VISITS', "Lühendatud külastused");
DEFINE('_EW_TRUNCATE_STATS', "Lühendatud andmed");
DEFINE('_EW_TRUNCATE_GOALS', "Lühendatud eesmärgid");
DEFINE('_EW_LIMIT_BOTS', "Piira bote");
DEFINE('_EW_LIMIT_VISITORS', "Limit Visitors");
DEFINE('_EW_TOOLTIP_WIDTH', "Kohtspikkri laius");
DEFINE('_EW_TOOLTIP_HEIGHT', "Kohtspikkri kõrgus");
DEFINE('_EW_TOOLTIP_URL', "Kohtspikkri URL");
DEFINE('_EW_TOOLTIP_ONCLICK', "Kohtspikkri OnClick");
DEFINE('_EW_IP_STATS', "IP statistika");
DEFINE('_EW_IPINFODB_KEY', "IP info AB võti ");
DEFINE('_EW_ONLY_LAST_URI', "Ainult viimane URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Peida esiotsa logo ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "Esiosa No Follow");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Esiosa no Back Link");
DEFINE('_EW_FRONTEND_USER_LINK', "Esiosa kasutaja lingid");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Esiosa riigid enne");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Esiosa riigide nimed");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Esiosa riigide suurtähed");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Esiosa riigide lipp ennem ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Esiosa riikide arv");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Esiosa riikide maks. veerud");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Esiosa riikide maks. read");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Esiosa tänased külastajad ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Esiosa eilsed külastajad ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Esiosa selle nädala külastajad ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Esiosa eelmise nädala külastajad ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Esiosa selle kuu külastajad ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Esiosa eelmise kuu külastajad ");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Esiosa Peida Külastajad kokku");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Esiosa Esialgne kokku");
DEFINE('_EW_HISTORY_MAX_VALUES', "Ajaloo maks. väärtused");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Ajaloo maks. andmed");
DEFINE('_EW_UPDATE_TIME_VISITS', "Uuenda külastus aega");
DEFINE('_EW_UPDATE_TIME_STATS', "Uuenda aja andmeid");
DEFINE('_EW_STATS_MAX_ROWS', "Maks. ridade statistika");
DEFINE('_EW_STATS_IP_HITS', "IP tabamuste statistika");
DEFINE('_EW_MAXID_BOTS', "Maks. ID botid");
DEFINE('_EW_MAXID_VISITORS', "Maks. ID külastajad");
DEFINE('_EW_STATS_KEEP_DAYS', "Statistika hoidmise päevad ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Puhverda esiosa riigid ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Puhverda esiosa külastajad ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Eemalda ja säilita andmed ");
DEFINE('_EW_IGNORE_IP', "Eira IP'd");
DEFINE('_EW_IGNORE_URI', "Eira URI");
DEFINE('_EW_IGNORE_USER', "Eira Kasutajat");
DEFINE('_EW_BLOCKING_MESSAGE', "Blokeerim sõnumit");
DEFINE('_EW_SERVER_URI_KEY', "Serveri URI võti");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Esiotsa kasutajate Esialgsed kokku");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Andmed");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Et blokeerimist tõhustada, pead avaldama ExtraWatch agendi ENNE sisu ja vorme. Nt. vasak pool mallis.
                    <br/>
                    Mine Mooduli haldur -> ExtraWatch agent -> Vali positsiooniks vasakule");
DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO aruanded");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO Öine e-maili aruanded lubatud");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Vaata paigaldamise demot");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
