<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "实时统计");
DEFINE('_EW_MENU_GOALS', "目标");
DEFINE('_EW_MENU_SETTINGS', "设置");
DEFINE('_EW_MENU_CREDITS', "积分");
DEFINE('_EW_MENU_FAQ', "常见问题");
DEFINE('_EW_MENU_DOCUMENTATION', "文件");
DEFINE('_EW_MENU_LICENSE', "许可证");
DEFINE('_EW_MENU_DONATORS', "支持者");
DEFINE('_EW_MENU_SUPPORT', "支持ExtraWatch以便从后台删除 ExtraWatch 的广告.");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "最新访客");
DEFINE('_EW_VISITS_BOTS', "机器人");
DEFINE('_EW_VISITS_CAME_FROM', "来自");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "你的ExtraWatch模块没有发布！没有新的统计信息被记录下来.发布它,去模块部分并把其在所有网页上发布");
DEFINE('_EW_VISITS_PANE_LOADING', "载入访问...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "一周访问统计");
DEFINE('_EW_STATS_WEEK', "周");
DEFINE('_EW_STATS_THIS_WEEK', "本周");
DEFINE('_EW_STATS_UNIQUE', "独特");
DEFINE('_EW_STATS_LOADS', "负载");
DEFINE('_EW_STATS_HITS', "点击");
DEFINE('_EW_STATS_TODAY', "今天");
DEFINE('_EW_STATS_FOR', "为");
DEFINE('_EW_STATS_ALL_TIME', "所有时间");
DEFINE('_EW_STATS_EXPAND', "扩大");
DEFINE('_EW_STATS_COLLAPSE', "崩溃");
DEFINE('_EW_STATS_URI', "页");
DEFINE('_EW_STATS_COUNTRY', "国家");
DEFINE('_EW_STATS_USERS', "用户");
DEFINE('_EW_STATS_REFERERS', "查阅情况");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "浏览器");
DEFINE('_EW_STATS_OS', "操作系统");
DEFINE('_EW_STATS_KEYWORDS', "关键词");
DEFINE('_EW_STATS_GOALS', "目标");
DEFINE('_EW_STATS_TOTAL', "共有");
DEFINE('_EW_STATS_DAILY', "日报");
DEFINE('_EW_STATS_DAILY_TITLE', "每日统计");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "所有时间统计");
DEFINE('_EW_STATS_LOADING', "加载...");
DEFINE('_EW_STATS_LOADING_WAIT', "载入中...请等待");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', " IP阻塞");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "手动输入IP");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "输入你要阻止IP地址. (如217.242.11.54或217 * 217.242 *阻止所有IP地址匹配的通配符)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "实时阻塞切换");
DEFINE('_EW_STATS_PANE_LOADING', "载入统计...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "设置");
DEFINE('_EW_SETTINGS_DEFAULT', "默认");
DEFINE('_EW_SETTINGS_SAVE', "保存");
DEFINE('_EW_SETTINGS_APPEARANCE', "外观");
DEFINE('_EW_SETTINGS_FRONTEND', "前台");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "历史与性能");
DEFINE('_EW_SETTINGS_ADVANCED', "高级");
DEFINE('_EW_SETTINGS_IGNORE', "忽略");
DEFINE('_EW_SETTINGS_BLOCKING', "阻止");
DEFINE('_EW_SETTINGS_EXPERT', "专家");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "你真的要重置所有统计和访问者数据?");
DEFINE('_EW_SETTINGS_RESET_ALL', "重置所有");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "重置所有统计访问者数据");
DEFINE('_EW_SETTINGS_LANGUAGE', "语言");
DEFINE('_EW_SETTINGS_SAVED', "设置被保存");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "添加您的IP ");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "到列表.");

// Other / mostly general.
DEFINE('_EW_TITLE', "一个实时的AJAX joomla监控");
DEFINE('_EW_BACK', "返回");
DEFINE('_EW_ACCESS_DENIED', "您没有权限查看此!");
DEFINE('_EW_LICENSE_AGREE', "我同意以上的条款与条件");
DEFINE('_EW_LICENSE_CONTINUE', "继续");
DEFINE('_EW_SUCCESS', "操作成功");
DEFINE('_EW_RESET_SUCCESS', "所有统计和访客数据擦除成功");
DEFINE('_EW_RESET_ERROR', "数据没有被成功擦除,出现异常");
DEFINE('_EW_CREDITS_TITLE', "积分");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "每日和每周的统计");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', " AJAX权限被拒绝: 请从你在Joomla的configuration.php中指定的域访问这些统计数据 ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "也许你只是忘记了在您的域名前面添加www.您的JavaScript试图访问");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "从");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "什么使得它认为这是一个不同的域.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "从获取最新的扩展的代码");
DEFINE('_EW_HEADER_CAST_YOUR', "请投下您的");
DEFINE('_EW_HEADER_VOTE', "投票");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "单击显示帮助提示");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "悬停鼠标显示帮助提示");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "昨日增加");
DEFINE('_EW_TOOLTIP_HELP', "打开外部网上帮助");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "关闭此窗口");
DEFINE('_EW_TOOLTIP_PRINT', "打印");

// Goals.
DEFINE('_EW_GOALS_INSERT', "插入一个新的目标");
DEFINE('_EW_GOALS_UPDATE', "更新的目标编号.");
DEFINE('_EW_GOALS_ACTION', "行动");
DEFINE('_EW_GOALS_TITLE', "新目标");
DEFINE('_EW_GOALS_NEW', "新目标");
DEFINE('_EW_GOALS_RELOAD', "刷新");
DEFINE('_EW_GOALS_ADVANCED', "高级");
DEFINE('_EW_GOALS_NAME', "名");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', " URI的条件");
DEFINE('_EW_GOALS_URI_INVERSED', " URI的反演条件");
DEFINE('_EW_GOALS_GET_VAR', "GET变量 ");
DEFINE('_EW_GOALS_GET_CONDITION', "GET条件");
DEFINE('_EW_GOALS_POST_VAR', "POST变量");
DEFINE('_EW_GOALS_POST_CONDITION', " POST条件");
DEFINE('_EW_GOALS_TITLE_CONDITION', "标题条件");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "用户名条件");
DEFINE('_EW_GOALS_IP_CONDITION', " IP条件");
DEFINE('_EW_GOALS_IP_INVERSED', "IP反演条件");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "来自条件");
DEFINE('_EW_GOALS_BLOCK', "阻止");
DEFINE('_EW_GOALS_REDIRECT', "重定向到URL ");
DEFINE('_EW_GOALS_HITS', "点击");
DEFINE('_EW_GOALS_ENABLED', "启用");
DEFINE('_EW_GOALS_EDIT', "编辑");
DEFINE('_EW_GOALS_DELETE', "删除");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "你将失去所有这一目标最近的统计数据.你真的要删除这个目标编号.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "国家");
DEFINE('_EW_FRONTEND_VISITORS', "访客");
DEFINE('_EW_FRONTEND_TODAY', "今天");
DEFINE('_EW_FRONTEND_YESTERDAY', "昨天");
DEFINE('_EW_FRONTEND_THIS_WEEK', "本周");
DEFINE('_EW_FRONTEND_LAST_WEEK', "上周");
DEFINE('_EW_FRONTEND_THIS_MONTH', "本月");
DEFINE('_EW_FRONTEND_LAST_MONTH', "上个月");
DEFINE('_EW_FRONTEND_TOTAL', "总计");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch运行在调试模式.通过这种方式,你可以发现错误的原因.要关闭它,请更改EXTRAWATCH_DEBUG 的值 /components/com_extrawatch/config.php 从1到0 ");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "当统计在扩展模式时显示的最大行数.");
DEFINE('_EW_DESC_STATS_IP_HITS', "过去几天中少于这个点击数值的所有IP地址将被从IP历史列表中删除.");
DEFINE('_EW_DESC_STATS_URL_HITS', "过去几天中少于这个点击数值的所有URL将被从IP历史列表中删除.");
DEFINE('_EW_DESC_IGNORE_IP', "从统计中排除某些IP.用一个新行分开.这里您可以使用通配符. <br/>例如: 192 .*会忽略192.168.51.31,192.168.16.2等.");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "访客刷新时间以毫秒为单位,默认是2000,不用随意修改此值.修改后请重新载入ExtraWatch后台.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "统计刷新时间以毫秒为单位,默认是4000,不用随意修改此值.修改后请重新载入ExtraWatch后台.");
DEFINE('_EW_DESC_MAXID_BOTS', "多少机器人访问保持在一个数据库中.");
DEFINE('_EW_DESC_MAXID_VISITORS', "多少真正的访问保持在一个数据库中.");
DEFINE('_EW_DESC_LIMIT_BOTS', "在后台显示多少机器人.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "在后台显示多少真正的访客.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "在长标题和URI中显示的最多字符数.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "在右侧统计面板中显示的最多字符数.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "在数据库中保存的统计信息的天数,0 =无限.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "当你和您的服务器处在不同的时区(正, 负多少小时)");
DEFINE('_EW_DESC_WEEK_OFFSET', "周偏移,时间戳/(3600 * 24 * 7)从1.1.1970周数,这个偏移是一种修正,使其从星期一开始 ");
DEFINE('_EW_DESC_DAY_OFFSET', "日偏移,时间戳/(3600 * 24)给天数从1.1.1970,这个偏移校正在00:00开始 ");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(专业版功能)</b>要使用前台1x1px的一个空白图标");
DEFINE('_EW_DESC_IP_STATS', "启用IP地址统计.在一些国家保持较长时间的IP数据库是被法律禁止的.使用者风险自负.");
DEFINE('_EW_DESC_HIDE_ADS', "如果后台广告惹恼了你, 通过此设置可以隐藏.多谢你的理解,通过这些广告的收入可以支持该软件的进一步发展");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "取消选中,如果你要显示的帮助提示, 可以悬停鼠标显示帮助提示.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "默认为'REDIRECT_URL',这是标准的,如果你使用URL重写,可以设置为'SCRIPT_URL',如果它仅记录 index.php ");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "消息显示被阻止的用户或进一步的信息,你为什么阻止这些用户.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "帮助提示宽度");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "说明文字高度");
DEFINE('_EW_DESC_TOOLTIP_URL', "在此处输入URL,可以查看对应的IP. {IP}访问者的IP地址将被替换.例如: http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "您可以输入想从统计中忽略的URI. 在这里, 您可以使用通配符(*和？). 例如:  /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "在这里指定一​​个目标名字.这个名字,你会在统计看到.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "域名后的其他内容. 例如 http://www.codegravity.com/projects/ the URI 是: /projects/ (例如: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', " GET变量是一个你可以在URL的?或者&后面看到的符号.例如: http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. 你也可以使用 <u>*</u> 来扫描所有的GET变量. (例如: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "在这里你必须指定一个匹配前面字段的值. (例如:<b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "颇为相似,但我们检查从表单提交的值.因此,当您在您的网站有一个表单,有一个字段&lt;input type='text' name='<u>experiences</u>' /&gt;. (例如: <b> exper * CES </b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "一个匹配POST字段中的值.例如:我们要检查用户是否有Java经验. (例如: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "相匹配的页面标题. (例如:<b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "一个登录用户名. (例如:<b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', " IP用户来自: (例如:<b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "用户来自于的URL. (例如:<b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "用户重定向到您指定的URL.有一个比'blocking'更高的优先级: (例如:<b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "多少个字符将被截断的目标表");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(专业版功能)</b>链接至codegravity.com,你可以禁用它,但我们会感激您保留它.谢谢");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "在前台模块显示国家总的统计.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "如果你想交换观众/国家在前台的顺序.取消选中它,访客将首先出现.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "在前台显示国家的数量");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "显示国家的访客在前台模块.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "多久缓存前台获取的全部国家, 单位为秒");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "多久缓存前台获取的全部访客, 单位为秒");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "显示在前台的访客: 今天.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "显示在前台的访客: 昨天.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "显示在前台的访客: 这个星期.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "显示在前台的访客: 上周.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "显示在前台的访客: 这个月.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "显示在前台的旅客: 上个月.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "显示自ExtraWatch安装后的全部访客.此设置更改后在前台生效的时间由后面变量确定 CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_LANGUAGE', "使用的语言文件.它们被放置在/components/com_extrawatch/lang/.如果你想创建一个全新的语言文件,首先检查 extrawatch 项目的主页,如果语言文件仍然是不存在的,只要复制默认的 english.php 到你要翻译的语言, 如. german.php 保存在同一个目录.然后翻译其中的所有键值.");
DEFINE('_EW_DESC_GOALS', "目标允许你指定特殊的参数.当这些参数匹配,目标计数器增加.这样你就可以监视用户是否具有访问某个特定的URL,发布一个特定的值,有一个特定的用户名或来自一个特定的地址.您还可以阻止或重定向这些用户到其他一些URL .");
DEFINE('_EW_DESC_GOALS_INSERT', "在除了name以外的所有的字段,你都可以使用*和？作为通配符.例如: ?ear (将匹配: near, tear, ..),  p*r (将匹配: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "设置为1,如果你想阻挡访客.除了显示封锁消息,他不会看到余下的内容,没有任何重定向而且他的IP添加到'阻挡'统计中(例如:<b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "国家条件");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "国家反演条件");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', " 2大写字母的国家代码(如: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "内部");
DEFINE('_EW_STATS_FROM', "从");
DEFINE('_EW_STATS_TO', "要");
DEFINE('_EW_STATS_ADD_TO_GOALS', "添加到目标");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "为这个国家添加目标");
DEFINE('_EW_MENU_REPORT_BUG', "报告错误或功能");
DEFINE('_EW_GOALS_COUNTRY', "国家");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "如果你想在前台让国家名称大写显示(例如:GERMANY, UNITED KINGDOM 而不是 Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "多久缓存前台获取的用户, 单位为秒");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "在总计中显示的初始值: 在前台.当你从其他统计工具迁移. (如: 20000).重新设置为0,如果你不想使用此功能.");
DEFINE('_EW_DESC_IGNORE_USER', "忽略在这个文本框中列出的用户.每行一个. (如: 自己{换行} mark_ *)");
DEFINE('_EW_FRONTEND_USERS_MOST', "今天最活跃的用户");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "启用基于下面的spamword列表的阻止功能?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "最常见的垃圾邮件,防垃圾邮件程序使用的词语.您可以使用通配符(如: ph?rmac*).如果上面的设置是启用的,ExtraWatch将检查攻击者是否通过(HTTP POST请求)的形式向你的网站提交垃圾邮件词汇. (如果表单只加载基于Joomla的网站 - 论坛,评论,对于阻止试图提交各种可能表单垃圾邮件机器人是相当有效的)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "防垃圾");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "在前台用户模块的链接 - 允许你指定一个当用户点击用户名时打开的URL,必须包含字符串 {user},这将被实际的用户名代替. (例如: index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "关键词");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "在历史标签的最大值(例如: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "在访问列表中只显示访问的最后一页,而不是所有");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "在访问列表中隐藏在访问页面标题重复的站点名");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "保存在访问历史数据库中的最大访客数量.小心使用此设置,如果你有高流量,增长的非常快.请务必检查状态中的历史表包含多少数据");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "卸载时保留数据库表.勾选此选项,如果你正在做升级之前卸载,并希望保持您的数据.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "您将夜间在收到前一天报告的电子邮件,方便你在早上阅读");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "您将收到这些报告的电子邮件地址");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "在电子邮件报告只包括比例值比 {value} 高的行.设置为0,如果你不想使用此功能<i>(例如: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "在电子邮件报告只包括变化值高于{value} ％的 <b>1天正值</b>.设置为0,如果你不想使用此功能<i>(例如: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "在电子邮件报告只包括变化值低于{value} ％的 <b>1天负值</b>.设置为0,如果你不想使用此功能<i>(例如: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "在电子邮件报告只包括变化值高于{value} ％的 <b>7天正值</b>.设置为0,如果你不想使用此功能<i>(例如: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "在电子邮件报告只包括变化值低于{value} ％的 <b>7天负值</b>.设置为0,如果你不想使用此功能<i>(例如: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "在电子邮件报告只包括变化值高于{value} ％的 <b>28天正值</b>.设置为0,如果你不想使用此功能<i>(例如: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "在电子邮件报告只包括变化值低于{value} ％的 <b>28天负值</b>.设置为0,如果你不想使用此功能<i>(例如: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(专业版功能)</b>启用此设置,如果你想标志链接中包含属性rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "电子邮件列名的最大字符数.更改此值,如果您的email客户端的消息窗口太小");

DEFINE('_EW_MENU_HISTORY', "历史");
DEFINE('_EW_MENU_EMAILS', "电子邮件");
DEFINE('_EW_MENU_STATUS', " DB状态");
DEFINE('_EW_DESC_BLOCKED', "这些IP阻止被防垃圾邮件功能");


DEFINE('_EW_HISTORY_VISITORS', "访客历史");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "显示只有 %d 的最后一个记录.
                要更改此值,去设置 -&gt; 历史与性能 -&gt; HISTORY_MAX_DB_RECORDS.要小心,此设置会影响下面的数据加载时间.  ");
DEFINE('_EW_MENU_BUG', "报告错误");
DEFINE('_EW_MENU_FEATURE', "请求功能");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "关键词");

DEFINE('_EW_BLOCKING_UNBLOCK', "疏通");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "表的名称");
DEFINE('_EW_STATUS_DATABASE_ROWS', "行");
DEFINE('_EW_STATUS_DATABASE_DATA', "数据");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "总");

DEFINE('_EW_EMAIL_REPORTS', "电子邮件报告");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "生成从昨天起的电子邮件过滤报告");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "电子邮件值过滤");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "值");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "％");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', " 1天的变化");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', " 7天的变化");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', " 28天的变化");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch今天阻止了 %d 的垃圾邮件发送者的点击,总记: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "封锁的 IP 地址");
DEFINE('_EW_ANTISPAM_SETTINGS', "反垃圾邮件设置");
DEFINE('_EW_TRAFFIC_AJAX', " AJAX更新交通(地图除外)");


DEFINE('_EW_HISTORY_PREVIOUS', "以前");
DEFINE('_EW_HISTORY_NEXT', "未来");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "国家的列数");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "国家的行数");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "是否显示国名");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "首先显示标志,然后再百分比");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "反演条件");
DEFINE('_EW_GOALS_POST_INVERSED', "发表反演条件");
DEFINE('_EW_GOALS_TITLE_INVERSED', "标题反演条件");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "用户名反演条件");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "来自反演条件");

DEFINE('_EW_STATS_MAP', "上次访问地图");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "请输入<a href='http://www.ipinfodb.com/register.php' target='_blank'> ipinfodb.com </ A>键以显示上次访问地图:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "存储的关键");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "请输入您是从有效ipinfodb关键码: <a href='http://www.ipinfodb.com/register.php' target='_blank'> ipinfodb.com </ A >");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "错误的请求: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "提交表单字段:");
DEFINE('_EW_VISIT_URL_PARAMETERS', " URL参数:");
DEFINE('_EW_VISIT_ADD_PAGE', "添加页面作为目标");
DEFINE('_EW_VISIT_BLOCK_IP', "封锁此IP地址");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', "添加的表单变量作为目标");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', "将此的URL参数作为目标");

DEFINE('_EW_TREND_EMPTY', "空");

DEFINE('_EW_NOT_NUMBER', "警告: 您输入的值不是一个数字. ExtraWatch不会正确工作!");
DEFINE('_EW_EVALUATION_LEFT', "这是15天评估版本.还剩下: <b>%d</b>.请购买终身<a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'> ExtraWatch 许可证,为您的域</a> 当前和后续的版本.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', "你的试用版已过期.请购买 ExtraWatch ");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "许可证激活成功.谢谢您");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>错误的许可证密钥,您的域名不匹配: </b> <br/>你输入的域名是否和你捐赠时填写的相同,如下? <br/>点击“<b>请求正确的激活密钥</b>”下面,或联系: info@codegravity.com <br/> ");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "如果您一直看到上面消息,您的实际网站设置可能是错误的的.
                    打开 components/com_extrawatch/config.php 文件
                    注释,并设置您的实际网站.例如:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "警告: 在您的浏览器中的网站的配置中的实际网站: %s and %s 不匹配.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "到设置实际网站:  %s 并继续...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "删除链接");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "知识库");
DEFINE('_EW_ADMINHEADER_FLOW', "流量");
DEFINE('_EW_ADMINHEADER_GRAPHS', "图");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "组件");
DEFINE('_EW_ADMINHEADER_REVIEW', "审查");
DEFINE('_EW_ADMINHEADER_WRITE', "写");

DEFINE('_EW_FLOW_TRAFFIC', "交通流");
DEFINE('_EW_FLOW_SELECT_PAGE', "选择页面:");
DEFINE('_EW_FLOW_OUTG_LINKS', "根外向链接数:");
DEFINE('_EW_FLOW_NESTING', "嵌套级别:");
DEFINE('_EW_FLOW_SCALE', "规模:");

DEFINE('_EW_COMERCIAL_AD_FREE', "带广告的免费版本");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "非常感谢您的捐赠!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "您的域 %s 的注册码是: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "现在你可以删除链接或隐藏在前台的ExtraWatch标志");


DEFINE('_EW_SIZES_LAST_CHECK', "最后一次检查是在:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "蓝色= 在 /administrator 文件夹中 component/module 的尺寸");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "组件");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "总计:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "大小");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "刷新所有");

DEFINE('_EW_SIZEDATABASE_TABLE', "表");
DEFINE('_EW_SIZEDATABASE_SIZE', "大小");
DEFINE('_EW_SIZEDATABASE_1DAY', " 1天的变化");
DEFINE('_EW_SIZEDATABASE_7DAY', " 7天的变化");
DEFINE('_EW_SIZEDATABASE_28DAY', " 28天的变化");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "没有数据");
DEFINE('_EW_SIZEDATABASE_TOTAL', "共有:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "刷新所有");
DEFINE('_EW_SIZEMODULES_TOTAL', "共有:");
DEFINE('_EW_SIZEMODULES_MODULE', "模块");
DEFINE('_EW_SIZEMODULES_SIZE', "大小");

DEFINE('_EW_SIZES_FILES', "文件和目录");
DEFINE('_EW_SIZES_BYTES', "字节");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "刷新");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "数据库表的大小");


DEFINE('_EW_DESC_IPINFODB_KEY', "最后访问地图ipinfodb.com键: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "强制时区偏移");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "更新");
DEFINE('_EW_MENU_UPDATE_TITLE', "备份和升级");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "在免费版本里不可用,请检查许可证选项卡");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "垃圾 单词班启用");
DEFINE('_EW_SPAMWORD_LIST', "垃圾 单词列表");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "隐藏重复的标题");
DEFINE('_EW_TRUNCATE_VISITS', "截断访问");
DEFINE('_EW_TRUNCATE_STATS', "截断统计");
DEFINE('_EW_TRUNCATE_GOALS', "截断目标");
DEFINE('_EW_LIMIT_BOTS', "限制机器人");
DEFINE('_EW_LIMIT_VISITORS', "限制访客");
DEFINE('_EW_TOOLTIP_WIDTH', "帮助提示宽度");
DEFINE('_EW_TOOLTIP_HEIGHT', "说明文字高度");
DEFINE('_EW_TOOLTIP_URL', "帮助提示的网址");
DEFINE('_EW_TOOLTIP_ONCLICK', "帮助提示 OnClick ");
DEFINE('_EW_IP_STATS', " IP统计");
DEFINE('_EW_IPINFODB_KEY', " IP信息数据库的关键字");
DEFINE('_EW_ONLY_LAST_URI', "只有最后的URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "前台隐藏标志");
DEFINE('_EW_FRONTEND_NOFOLLOW', "前台没有后续");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "前台没有返回链接");
DEFINE('_EW_FRONTEND_USER_LINK', "前台用户链接");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "前台的国家第一");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "前台的国家名称");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "前台国家的大写");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "前台各国国旗第一");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "前台的国家数量");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "前台国家的最大列数 ");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "前台国家的最大行数");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "今天前台访客");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "昨天前台访客");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "本周前台访客");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "上周前台访客");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "本月前台访客");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "上个月前台访客");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "前台隐藏访客总记");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "前台总计初步");
DEFINE('_EW_HISTORY_MAX_VALUES', "历史最高值");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "历史最高记录");
DEFINE('_EW_UPDATE_TIME_VISITS', "更新时间访问");
DEFINE('_EW_UPDATE_TIME_STATS', "更新时间统计");
DEFINE('_EW_STATS_MAX_ROWS', "统计最大行");
DEFINE('_EW_STATS_IP_HITS', "统计的IP点击");
DEFINE('_EW_MAXID_BOTS', "最大ID机器人");
DEFINE('_EW_MAXID_VISITORS', " 最大ID访客");
DEFINE('_EW_STATS_KEEP_DAYS', "统计保持天数");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "缓存前台国家");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "缓存前台访客");

DEFINE('_EW_UNINSTALL_KEEP_DATA', "卸载保持数据");
DEFINE('_EW_IGNORE_IP', "忽略IP ");
DEFINE('_EW_IGNORE_URI', "忽略URI ");
DEFINE('_EW_IGNORE_USER', "忽略用户");
DEFINE('_EW_BLOCKING_MESSAGE', "非阻塞消息");
DEFINE('_EW_SERVER_URI_KEY', "服务器URI关键码");
DEFINE('_EW_SIZEDATABASE_RECORDS', "记录");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', "为了使阻塞有效,你需要把ExtraWatch代理 发布在任何内容和表单之前.例如:在您的模板的左侧.
                    <br/>
                    进入模块管理 - >ExtraWatch代理 - >选择位置左");

DEFINE('_EW_EMAIL_SEO_REPORTS', " SEO报告");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', " SEO每晚电子邮件报告启用");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "观看安装演示");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");

/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
